import java.io.File;
import java.util.List;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import com.justinmind.prototyper.api.API;
import com.justinmind.prototyper.api.IPrototype;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.component.ICanvasComponent;
import com.justinmind.util.file.FileUtils;

public class JustInMindControlType {
	public static void main(String[] args) {
		FileDialog dialog = new FileDialog(new Shell());
		String path_to_vp = dialog.open();
		{
			try {
				String temp_directory = System.getProperty("java.io.tmpdir");

				// Delete temporarily directory
				FileUtils.deepDeleteDirExceptRoot(temp_directory
						+ File.separator + "work");

				FileUtils.unZip(path_to_vp, temp_directory + File.separator
						+ "work");
				IPrototype prototype = API.getPrototypeLoader().loadPrototype(
						temp_directory + File.separator + "work");
				
				List<ICanvas> canvas = prototype.getApiCanvases();
				for (ICanvas iCanvas : canvas)
				{
					List<ICanvasComponent> lstICanvasComponent = iCanvas
							.getApiRoot().getApiChildren();

					for (ICanvasComponent iCanvasComponent : lstICanvasComponent)
					{
						String controlType = iCanvasComponent
								.getApiWidgetName();

						System.out.println("Control Type :" + controlType);
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

}
